package ru.yandex.tours.wizard.index

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata._
import ru.yandex.tours.index.WizardIndex
import ru.yandex.tours.index.composite.ShardedIndex
import ru.yandex.tours.index.shard.IndexShard
import ru.yandex.tours.wizard.resource.{ResourceHolder, ShardHolder}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.03.15
 */
class LongIndexHolder(shards: Vector[IndexShard], val name: String)
  extends ResourceHolder[WizardIndex] with MonitoredIndexHolder {

  val getResource: WizardIndex = new ShardedIndex(shards)

  def size: Int = shards.map(_.size).sum
}

object LongIndexHolder {
  def apply(name: String, dir: File, extDataService: ExtDataService, extDataUpdateChecker: ExtDataUpdateChecker): LongIndexHolder = {
    val shards =
      DataTypes.wizardIndex.dataTypes
        .map { dt => new ShardHolder(dir, dt, IndexShard).from(extDataService, extDataUpdateChecker) }
    new LongIndexHolder(shards.toVector, name)
  }
}
