package ru.yandex.tours.wizard.microoffer

import java.io.File

import ru.yandex.tours.index.WizardIndexing
import ru.yandex.tours.util.Logging
import ru.yandex.tours.wizard.resource.FreshResourceHolder

import scala.concurrent.duration.FiniteDuration

/**
  * Created by asoboll on 31.01.17.
  */
class FreshMicroOfferHolder(val ttl: FiniteDuration, val name: String)
  extends FreshResourceHolder[MicroOfferIndexImpl] with MonitoredMicroOfferHolder {

  protected def buildResource(): MicroOfferIndexImpl = FreshMicroOfferHolder.join(shards)

  def size = resource.get.size
}

object FreshMicroOfferHolder extends Logging {
  def fromDirectory(name: String, dir: File, ttl: FiniteDuration): FreshMicroOfferHolder = {
    val holder = new FreshMicroOfferHolder(ttl, name)
    holder.addShards(MicroOfferIndexImpl.allFromDir(dir, WizardIndexing.MicroOffers.extension))
    holder
  }

  def join(shards: Vector[MicroOfferIndexImpl]): MicroOfferIndexImpl = {
    log.info(s"Joining ${shards.size} fresh shards")
    val freshness = shards.foldLeft(System.currentTimeMillis()) { _ min _.freshness }
    val hotels = MicroOfferIndex.distinctHotels(shards.flatMap(_.iterator))
    MicroOfferIndexImpl.fromIterator(freshness, hotels)
  }
}
