package ru.yandex.tours.wizard.microoffer

import java.io.File

import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.{DataTypes, ExtDataUpdateChecker}
import ru.yandex.tours.wizard.resource.{ResourceHolder, ShardHolder}

/**
  * Created by asoboll on 01.02.17.
  */
class LongMicroOfferHolder(shards: Vector[MicroOfferIndexImpl], val name: String)
  extends ResourceHolder[MicroOfferIndex] with MonitoredMicroOfferHolder {

  val getResource: MicroOfferIndex = new ShardedMicroOfferIndex(shards)

  def size: Int = shards.map(_.size).sum
}

object LongMicroOfferHolder {
  def apply(name: String, dir: File, extDataService: ExtDataService,
            extDataUpdateChecker: ExtDataUpdateChecker): LongMicroOfferHolder = {
    val shards = DataTypes.shardedMicroOffers.dataTypes
      .map { dt => new ShardHolder(dir, dt, MicroOfferIndexImpl).from(extDataService, extDataUpdateChecker) }
    new LongMicroOfferHolder(shards.toVector, name)
  }
}
