package ru.yandex.tours.wizard.parser

import com.codahale.metrics.MetricRegistry
import ru.yandex.tours.wizard.query.ParsedUserQuery

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 16.03.15
 */
trait BadQueryReporter {
  def noMarker(userRequest: String)
  def stopWords(userRequest: String)

  def unknownParts(parsedQuery: ParsedUserQuery)
  def someRegions(parsedQuery: ParsedUserQuery)
  def manyDeparture(parsedQuery: ParsedUserQuery)
  def manyArrival(parsedQuery: ParsedUserQuery)
  def manyHotels(parsedQuery: ParsedUserQuery)
  def manyOperators(parsedQuery: ParsedUserQuery)
}

object BadQueryReporter {
  def empty = {
    new BadQueryReporter {
      override def manyOperators(parsedQuery: ParsedUserQuery): Unit = ()
      override def manyArrival(parsedQuery: ParsedUserQuery): Unit = ()
      override def noMarker(userRequest: String): Unit = ()
      override def manyDeparture(parsedQuery: ParsedUserQuery): Unit = ()
      override def manyHotels(parsedQuery: ParsedUserQuery): Unit = ()
      override def stopWords(userRequest: String): Unit = ()
      override def unknownParts(parsedQuery: ParsedUserQuery): Unit = ()
      override def someRegions(parsedQuery: ParsedUserQuery): Unit = ()
    }
  }
}

class InstrumentedBadQueryReporter(metrics: MetricRegistry) extends BadQueryReporter {
  private val prefix = "wizard.parser."
  private val unknown = metrics.meter(prefix + "unknown")
  private val noMarker = metrics.meter(prefix + "no_marker")
  private val stopWords = metrics.meter(prefix + "stop_words")
  private val someRegion = metrics.meter(prefix + "some_region")
  private val manyDeparture = metrics.meter(prefix + "many_departure")
  private val manyArrival = metrics.meter(prefix + "many_arrival")
  private val manyHotels = metrics.meter(prefix + "many_hotels")
  private val manyOperators = metrics.meter(prefix + "many_operators")

  override def noMarker(userRequest: String): Unit = noMarker.mark()
  override def stopWords(userRequest: String): Unit = stopWords.mark()
  override def unknownParts(parsedQuery: ParsedUserQuery): Unit = unknown.mark()
  override def someRegions(parsedQuery: ParsedUserQuery): Unit = someRegion.mark()
  override def manyDeparture(parsedQuery: ParsedUserQuery): Unit = manyDeparture.mark()
  override def manyArrival(parsedQuery: ParsedUserQuery): Unit = manyArrival.mark()
  override def manyHotels(parsedQuery: ParsedUserQuery): Unit = manyHotels.mark()
  override def manyOperators(parsedQuery: ParsedUserQuery): Unit = manyOperators.mark()
}