package ru.yandex.tours.wizard.query

import ru.yandex.tours.query.parser.ParsingTrie
import ru.yandex.tours.util.text.StringNormalizer.normalizeString
import ru.yandex.tours.util.trie.AhoCorasickMachine
import ru.yandex.tours.wizard.query.ParsedUserQuery.QueryPart

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 30.01.15
 */
class PragmaticsParser(parsingTrie: ParsingTrie) {

  def findAny(userRequest: String): Boolean = {
    val ac = new AhoCorasickMachine(parsingTrie.trie, normalizeString(userRequest), false)

    var state = ac.findNext()
    while (state ne AhoCorasickMachine.State.END) {
      if (state eq AhoCorasickMachine.State.TERMINAL) {
        return true
      }
      state = ac.findNext()
    }
    false
  }

  def exists(userRequest: String, matcher: QueryPart => Boolean): Boolean = {
    val trie = parsingTrie.copy()
    val ac = new AhoCorasickMachine(trie.trie, normalizeString(userRequest), false)

    var state = ac.findNext()
    while (state ne AhoCorasickMachine.State.END) {
      if (state eq AhoCorasickMachine.State.TERMINAL) {
        if (getQueryParts(userRequest, ac, trie).exists(matcher)) {
          return true
        }
      }
      state = ac.findNext()
    }
    false
  }

  def parse(userRequest: String, debugMode: Boolean = false): ParsedUserQuery = {
    val normalized = normalizeString(userRequest)
    val trie = parsingTrie.copy()
    val ac = new AhoCorasickMachine(trie.trie, normalized, debugMode)
    val queryParts = Vector.newBuilder[QueryPart]

    var state = ac.findNext()
    while (state ne AhoCorasickMachine.State.END) {
      if (state eq AhoCorasickMachine.State.TERMINAL) {
        queryParts ++= getQueryParts(normalized, ac, trie)
      }
      state = ac.findNext()
    }
    ParsedUserQuery(normalized, queryParts.result())
  }

  private def getQueryParts(userRequest: String, ac: AhoCorasickMachine, trie: ParsingTrie) = {
    val patterns = trie.getPragmatics(ac.getStateId)

    val endPosition = ac.getPosition
    for (pattern <- patterns.iterator if endPosition - pattern.length >= 0) yield {
      ParsedUserQuery.QueryPart(userRequest, endPosition - pattern.length, endPosition, pattern.pragmatic)
    }
  }
}
