package ru.yandex.tours.wizard.resource

import java.util.concurrent.atomic.AtomicReference

import scala.concurrent.duration.{FiniteDuration, _}

/**
  * Created by asoboll on 26.01.17.
  */
abstract class FreshResourceHolder[R <: ExpiringWizardResource]
  extends ResourceHolder[R] {

  def ttl: FiniteDuration

  protected implicit val ordering = Ordering.by[R, Long](_.freshness).reverse

  @volatile
  protected var shards: Vector[R] = Vector.empty
  protected val resource: AtomicReference[R] = new AtomicReference[R](buildResource())

  protected def buildResource(): R

  def getResource: R = resource.get

  def addShard(shard: R): Unit = {
    shards = shards :+ shard
    update()
  }

  def addShards(newShards: Seq[R]): Unit = {
    shards = shards ++ newShards
    update()
  }

  def update(): Unit = {
    val (alive, dead) = shards partition (_.isAlive(ttl))
    dead.foreach(_.closeAfter(1.minute))
    shards = alive.sorted

    val newIndex = buildResource()
    newIndex.load()
    val oldIndex = resource.getAndSet(newIndex)
    oldIndex.closeAfter(1.minute)
    oldIndex.delete()
  }

}
