package ru.yandex.tours.wizard.resource

import akka.actor.ActorSystem
import ru.yandex.tours.util.{Logging, Metrics, Monitorings}

import scala.concurrent.duration.{FiniteDuration, _}
import scala.util.control.NonFatal

/**
  * Created by asoboll on 26.01.17.
  */
trait MonitoredResourceHolder extends ResourceHolder[WizardResource] with Logging {

  def size: Int
  def isEmpty: Boolean
  def monPath: String
  def resoureName: String

  def startMonitoring(isCritical: Boolean, interval: FiniteDuration = 1.minute)
                     (implicit akka: ActorSystem): Unit = {
    val monitorings = Monitorings(monPath)
    val isEmptyMonitoring = monitorings.state("empty")

    akka.scheduler.schedule(interval, interval) {
      try {
        if (isEmpty) {
          if (isCritical) isEmptyMonitoring.setCritical(s"$resoureName is empty")
          else isEmptyMonitoring.setWarning(s"$resoureName is empty")
        } else isEmptyMonitoring.setOk()
      } catch {
        case NonFatal(t) =>
          log.error(s"Can not get $resoureName", t)
      }
    }(akka.dispatcher)

    Metrics(monPath).newGauge("size") { size }
  }
}
