package ru.yandex.tours.wizard.resource

import java.io.File

import akka.actor.Actor
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.file._

import scala.concurrent.duration._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.03.15
 */
class ResourceReceiver[R <: ExpiringWizardResource](resourceHolder: FreshResourceHolder[R],
                                                    resourceLoader: WizardResourceLoader[R],
                                                    dir: File,
                                                    name: String) extends Actor with Logging {
  import context.dispatcher

  private case object Update
  private val ticker = context.system.scheduler.schedule(1.minute, 1.minute, self, Update)
  private var lastUpdate = 0L

  override def postStop(): Unit = {
    ticker.cancel()
  }

  override def receive: Receive = {
    case resource: RawResource =>
      log.info(s"Received raw $name of size ${resource.size} bytes (gzipped = ${resource.gzipped})")
      val file = dir / resource.uniqueFileName
      resource.writeTo(file)

      val shard = resourceLoader.fromFile(file)

      log.info("Received shard: " + shard)
      resourceHolder.addShard(shard)
      lastUpdate = System.currentTimeMillis()
    case Update if lastUpdate < System.currentTimeMillis() - 1.minute.toMillis =>
      resourceHolder.update()
      lastUpdate = System.currentTimeMillis()
    case obj =>
      log.info(s"Got message: " + obj)
  }
}
