package ru.yandex.tours.wizard.resource

import java.io.{File, FileOutputStream, InputStream}

import org.apache.commons.io.IOUtils
import ru.yandex.extdata.common.exception.{DataIsNotLoadedException, UnableToLoadDataException}
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.DataDef
import ru.yandex.tours.util.file._
import ru.yandex.tours.util.{IO, Logging}

import scala.concurrent.duration._
import scala.reflect.ClassTag

/**
  * Created by asoboll on 01.02.17.
  */
class ShardHolder[T <: WizardResource : ClassTag](dir: File,
                                                  val dataType: DataType,
                                                  dataLoader: WizardResourceLoader[T]) extends DataDef[T] with Logging {

  override def from(extDataService: ExtDataService): T = {
    try {
      super.from(extDataService)
    } catch {
      case _: DataIsNotLoadedException | _: UnableToLoadDataException =>
        log.warn(s"No previous ${dataType.getName}. Using empty one.")
        dataLoader.empty
    }
  }

  override def parse(is: InputStream): T = {
    val fileName = s"${System.currentTimeMillis()}_$dataType"
    val file = dir / fileName
    IO.using(new FileOutputStream(file)) { os => IOUtils.copy(is, os) }

    val shard = dataLoader.fromFile(file)
    shard.load()
    shard
  }

  override protected def onChange(oldValue: Option[T], newValue: T): Unit = {
    oldValue.foreach(_.closeAfter(1.minute))
    oldValue.foreach(_.delete())
  }
}
