package ru.yandex.tours.wizard.search

import ru.yandex.tours.model.wizard.MicroOffer.HotelMicroOffersProto
import ru.yandex.tours.wizard.domain.{HotelPricesResponse, HotelSnippetResponse, ToursWizardRequest, ToursWizardResponse}

/**
  * Created by asoboll on 15.02.17.
  */
class AddOffersToursSearcher(searcher: WizardToursSearcher,
                             offersSearchers: MicroOffersSearcher*) extends WizardToursSearcher {
  override def search(request: ToursWizardRequest): Option[ToursWizardResponse] = {
    searcher.search(request).map {
      case hsr: HotelSnippetResponse => hsr.copy(offers = searchOffers(hsr.hotel.id))
      case hpr: HotelPricesResponse => hpr.copy(offers = searchOffers(hpr.hotel.id))
      case any => any
    }
  }

  private def searchOffers(hotelId: Int): Option[HotelMicroOffersProto] = {
    val i = offersSearchers.toIterator.flatMap(_.searchOffers(hotelId))
    if (i.hasNext) Some(i.next())
    else Option.empty
  }
}
