package ru.yandex.tours.wizard.search

import java.util.concurrent.{Callable, TimeUnit}
import java.util.concurrent.atomic.AtomicInteger

import com.google.common.cache.CacheBuilder
import ru.yandex.tours.direction.Direction
import ru.yandex.tours.wizard.domain.{TourStartInterval, DirectionWithPrice, ToursWizardRequest}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 01.06.15
 */
trait DirectionCaching extends IndexToursSearcher {
  private val cache = CacheBuilder.newBuilder
    .expireAfterWrite(1, TimeUnit.MINUTES)
    .maximumSize(10000)
    .build[(Int, Int, TourStartInterval, Int), Option[DirectionWithPrice]]

  override protected def directionBestPrice(direction: Direction, request: ToursWizardRequest, i: AtomicInteger): Option[DirectionWithPrice] = {
    def sup = super.directionBestPrice(direction, request, i)
    val operatorId = request.operator.getOrElse(0)
    cache.get((request.from, direction.region.id, request.when, operatorId), new Callable[Option[DirectionWithPrice]] {
      override def call(): Option[DirectionWithPrice] = sup
    })
  }
}
