package ru.yandex.tours.wizard.search

import ru.yandex.tours.wizard.domain.{ToursWizardRequest, ToursWizardResponse}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 09.06.15
 */
class FallbackDepartureToursSearcher(searcher: WizardToursSearcher) extends WizardToursSearcher {
  override def search(request: ToursWizardRequest): Option[ToursWizardResponse] = {
    searcher.search(request).orElse {
      request.fallbackFrom.foldLeft(Option.empty[ToursWizardResponse]) {
        case (res @ Some(_), _) => res
        case (None, fallback) =>
          val fallbackRequest = request.copy(from = fallback)
          searcher.search(fallbackRequest)
      }
    }
  }
}
