package ru.yandex.tours.wizard.search

import com.codahale.metrics.MetricRegistry
import ru.yandex.tours.util.Logging

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 14.03.15
 */
trait InstrumentedSearcher extends Logging {

  def marker: String
  def metrics: MetricRegistry

  val timer = metrics.timer(MetricRegistry.name("wizard.searcher", marker.toLowerCase, "time"))
  val found = metrics.meter(MetricRegistry.name("wizard.searcher", marker.toLowerCase, "found"))
  val notFound = metrics.meter(MetricRegistry.name("wizard.searcher", marker.toLowerCase, "not_found"))

  protected def instrumentedSearch[R, T](action: (R) => Option[T])(request: R): Option[T] = {
    val ctx = timer.time()
    val result = action(request)
    val time = ctx.stop() / 1000000
    if (result.isDefined) {
      found.mark()
      if (log.isDebugEnabled) {
        log.debug(s"Searcher [$marker] found result in $time ms. for $request")
      }
    } else {
      notFound.mark()
      if (log.isDebugEnabled) {
        log.debug(s"Searcher [$marker] got nothing in $time ms. for $request")
      }
    }
    result
  }
}
