package ru.yandex.tours.wizard.search

import ru.yandex.tours.util.Logging
import ru.yandex.tours.wizard.domain.{Relevance, ToursWizardRequest, ToursWizardResponse}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.07.15
 */
class LoggingToursSearcher(searcher: WizardToursSearcher) extends WizardToursSearcher with Logging {
  override def search(request: ToursWizardRequest): Option[ToursWizardResponse] = {
    val result = searcher.search(request)
    result match {
      case None =>
        log.info("Nothing found for request " + request)
      case Some(res) =>
        val relevance = Relevance(request, res)
        log.info(s"Found [${res.wizardType.getCounter}] for request $request with relevance = $relevance")
    }
    result
  }
}
