package ru.yandex.tours.wizard.search

import ru.yandex.tours.model.wizard.MicroOffer.HotelMicroOffersProto
import ru.yandex.tours.wizard.WizardTracer
import ru.yandex.tours.wizard.microoffer.MicroOfferHolder

/**
  * Created by asoboll on 15.02.17.
  */
class MicroOffersSearcher(microOfferHolder: MicroOfferHolder) {
  def searchOffers(hotelId: Int): Option[HotelMicroOffersProto] = {
    microOfferHolder.getResource.get(hotelId)
  }
}

trait InstrumentedMicroOffersSearcher extends MicroOffersSearcher with InstrumentedSearcher {
  override abstract def searchOffers(hotelId: Int): Option[HotelMicroOffersProto] = {
    WizardTracer.checkpoint("start_search_" + marker)
    val ans = instrumentedSearch(super.searchOffers)(hotelId)
    WizardTracer.checkpoint("finish_" + marker, ans.size)
    ans
  }
}
