package ru.yandex.tours.wizard.search

import ru.yandex.tours.direction.Directions
import ru.yandex.tours.geo.base.region

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 11.11.15
 */
object Regions {
  //HOTELS-305
  private val ignoredCountries = Set(
    225, //Россия
    149  //Беларусь
  )

  private val preferToursDirections = Set(
    983,  //Турция
    1056, //Египет
    20574 //Кипр
  )

  private val preferRoomsDirections = Set(
    11508 //Стамбул
  )

  private val preferDirections = preferToursDirections ++ preferRoomsDirections

  def ignoreSearch(to: Int) = {
    ignoredCountries.contains(to)
  }

  def isSkyResort(to: Option[Int], directions: Directions) = {
    to.flatMap(directions.get).exists(_.ski.nonEmpty)
  }
  
  def preferTours(to: Int, tree: region.Tree) = {
    val path = tree.pathToRoot(to).map(_.id)
    path.find(preferDirections.contains)
      .exists(preferToursDirections.contains)
  }
}
