package ru.yandex.tours.wizard.search

import ru.yandex.tours.util.Logging
import ru.yandex.tours.wizard.domain.{ToursWizardResponse, ToursWizardRequest}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 12.03.15
 */
class SequenceToursSearcher(searchers: WizardToursSearcher*) extends WizardToursSearcher with Logging {
  override def search(request: ToursWizardRequest): Option[ToursWizardResponse] = {
    val i = searchers.toIterator.flatMap(_.search(request))

    if (i.hasNext) Some(i.next())
    else Option.empty
  }
}
