package ru.yandex.tours.wizard.search

import ru.yandex.tours.wizard.WizardTracer
import ru.yandex.tours.wizard.domain.{ToursWizardRequest, ToursWizardResponse}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.02.15
 */
trait WizardToursSearcher {
  def search(request: ToursWizardRequest): Option[ToursWizardResponse]
}

trait InstrumentedToursSearcher extends WizardToursSearcher with InstrumentedSearcher {
  override abstract def search(request: ToursWizardRequest): Option[ToursWizardResponse] = {
    WizardTracer.checkpoint("start_search_" + marker)
    instrumentedSearch(super.search)(request)
  }
}
