package trainbanditapi

import (
	"context"
	"fmt"

	staticresolver "a.yandex-team.ru/travel/library/go/grpcutil/client/static_resolver"
	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"

	banditpb "a.yandex-team.ru/travel/rasp/train_bandit_api/proto"
)

type ClientConfig struct {
	StaticTarget string `config:"trainbanditapi-static-target,required" yaml:"static-target"`
}

var DefaultConfig = ClientConfig{
	StaticTarget: "static:///travel-trains-bandit-testing.balancer.internal.yandex.net:9111",
}

func createConnection(ctx context.Context, config ClientConfig) (*grpc.ClientConn, error) {
	return grpc.DialContext(
		ctx,
		config.StaticTarget,
		grpc.WithResolvers(staticresolver.NewStaticResolverBuilder()),
		grpc.WithTransportCredentials(insecure.NewCredentials()),
		grpc.WithBlock(),
	)
}

func CreateClient(ctx context.Context, config ClientConfig) (banditpb.BanditApiServiceV1Client, error) {
	conn, err := createConnection(ctx, config)
	if err != nil {
		return nil, fmt.Errorf("cannot create connection: %w", err)
	}
	return banditpb.NewBanditApiServiceV1Client(conn), nil
}
