package models

const (
	TransportTypeTrain = "train"
)

type Country struct {
	Code string `json:"code"`
	ID   int    `json:"id"`
}

type StationCodes struct {
	Express string `json:"express"`
}

type Settlement struct {
	ID              int    `json:"id"`
	Title           string `json:"title"`
	TitleGenitive   string `json:"titleGenitive"`
	TitleLocative   string `json:"titleLocative"`
	Preposition     string `json:"preposition"`
	TitleAccusative string `json:"titleAccusative"`
}

type Station struct {
	ID              int          `json:"id"`
	Title           string       `json:"title"`
	PopularTitle    string       `json:"popularTitle"`
	SettlementID    int          `json:"settlementId"`
	Timezone        string       `json:"timezone"`
	RailwayTimezone string       `json:"railwayTimezone"`
	Country         Country      `json:"country"`
	Codes           StationCodes `json:"codes"`
	Settlement      Settlement   `json:"settlement"`
	Platform        string       `json:"platform"`
}

type TransportModel struct {
	Title string `json:"title"`
}

type TransportSubtype struct {
	ID         int    `json:"id"`
	Code       string `json:"code"`
	Title      string `json:"title"`
	TitleColor string `json:"titleColor"`
}

type Transport struct {
	Code    string           `json:"code"`
	ID      int              `json:"id"`
	Title   string           `json:"title"`
	Model   TransportModel   `json:"model"`
	Subtype TransportSubtype `json:"subtype"`
}

type DeluxeTrain struct {
	ID          int    `json:"id"`
	Title       string `json:"title"`
	ShortTitle  string `json:"shortTitle"`
	IsDeluxe    bool   `json:"isDeluxe"`
	IsHighSpeed bool   `json:"isHighSpeed"`
	PagePath    string `json:"pagePath"`
}
