package models

import "time"

type Price struct {
	Value    float32 `json:"value"`
	Currency string  `json:"currency"`
}

type OrderRequest struct {
	HTTPMethod string      `json:"httpMethod"`
	URL        string      `json:"url"`
	Params     interface{} `json:"params"`
	Headers    interface{} `json:"headers"`
}

const (
	TrainOrderURLOwnerTrains = "trains"
	TrainOrderURLOwnerUfs    = "ufs"
)

type ClassPrice struct {
	Price                  Price        `json:"price"`
	ServicePrice           Price        `json:"servicePrice"`
	Seats                  int          `json:"seats"`
	LowerSeats             *int         `json:"lowerSeats"`
	UpperSeats             *int         `json:"upperSeats"`
	LowerSideSeats         *int         `json:"lowerSideSeats"`
	UpperSideSeats         *int         `json:"upperSideSeats"`
	HasNonRefundableTariff bool         `json:"hasNonRefundableTariff"`
	OrderURL               string       `json:"orderUrl"`
	OrderRequest           OrderRequest `json:"partnerOrderRequest"`
	TrainOrderURL          string       `json:"trainOrderUrl"`
	TrainOrderURLOwner     string       `json:"trainOrderUrlOwner"`
	DeepURL                Price        `json:"deepUrl"`
}

type Classes struct {
	Compartment ClassPrice `json:"compartment"`
	Suite       ClassPrice `json:"suite"`
	Sitting     ClassPrice `json:"sitting"`
	Platzkarte  ClassPrice `json:"platzkarte"`
	Soft        ClassPrice `json:"soft"`
	Common      ClassPrice `json:"common"`
}

const (
	TariffErrorUnknown                      = 0
	TariffErrorSoldOut                      = 1
	TariffErrorTransitDocumentRequired      = 2
	TariffErrorNotAvailableInWeb            = 3
	TariffErrorFeatureNotAllowed            = 4
	TariffErrorServiceNotAllowed            = 5
	TariffErrorCarrierNotAllowedForSale     = 6
	TariffErrorOtherReasonOfInaccessibility = 7
	TariffErrorUnsupportedReservationType   = 8
	TariffErrorTooCheap                     = 9
	TariffErrorUnsupportedCoachType         = 10
	TariffErrorChildTariff                  = 11
)

type BrokenClasses struct {
	Unknown     []int `json:"unknown"`
	Soft        []int `json:"soft"`
	Platzkarte  []int `json:"platzkarte"`
	Compartment []int `json:"compartment"`
	Suite       []int `json:"suite"`
	Common      []int `json:"common"`
	Sitting     []int `json:"sitting"`
}

type SegmentTariffs struct {
	ElectronicTicket bool          `json:"electronicTicket"`
	Classes          Classes       `json:"classes"`
	BrokenClasses    BrokenClasses `json:"brokenClasses"`
}

type SchedulePlan struct {
	Code      string    `json:"code"`
	Title     string    `json:"title"`
	StartDate time.Time `json:"startDate"`
	EndDate   time.Time `json:"endDate"`
}

// Not supported:
//      displaceYabus
type Thread struct {
	UID              string      `json:"uid"`
	Title            string      `json:"title"`
	Number           string      `json:"number"`
	IsExpress        bool        `json:"isExpress"`
	IsAeroExpress    bool        `json:"isAeroExpress"`
	DeluxeTrain      DeluxeTrain `json:"deluxeTrain"`
	BeginTime        time.Time   `json:"beginTime"`
	EndTime          time.Time   `json:"endTime"`
	Density          string      `json:"density"`
	SchedulePlanCode string      `json:"schedulePlanCode"`
	IsBasic          bool        `json:"isBasic"`
	Comment          string      `json:"comment"`
	FirstCountryCode string      `json:"firstCountryCode"`
	LastCountryCode  string      `json:"lastCountryCode"`
}

type Company struct {
	ID         int    `json:"id"`
	Title      string `json:"title"`
	ShortTitle string `json:"shortTitle"`
	UFSTitle   string `json:"ufsTitle"`
	URL        string `json:"url"`
	Hidden     bool   `json:"hidden"`
}

type RunDays interface{}

// Not supported:
//	   days_by_tz = DictNestedField(DaysSchema, dump_to='daysByTimezone')
type SegmentWithTariffs struct {

	// Common for trainapi and mordabackend
	ID             string        `json:"id"`
	Title          string        `json:"title"`
	Arrival        time.Time     `json:"arrival"`
	Departure      time.Time     `json:"departure"`
	Duration       time.Duration `json:"duration"`
	StationFrom    Station       `json:"stationFrom"`
	StationTo      Station       `json:"stationTo"`
	StartDate      string        `json:"startDate"`
	Transport      Transport     `json:"transport"`
	Thread         Thread        `json:"thread"`
	Company        Company       `json:"company"`
	IsThroughTrain bool          `json:"isThroughTrain"`
	Stops          string        `json:"stops"`
	DoNotSell      bool          `json:"doNotSell"`
	OldUfsOrder    string        `json:"oldUfsOrder"`
	URL            string        `json:"url"`
	Number         string        `json:"number"`

	// trainapi
	SalesLimitInDays  int            `json:"salesLimitInDays"`
	Key               string         `json:"key"`
	OriginalNumber    string         `json:"originalNumber"`
	CanSupplySegments bool           `json:"canSupplySegments"`
	Tariffs           SegmentTariffs `json:"tariffs"`
	RawTrainCategory  string         `json:"rawTrainCategory"`
	RawTrainName      string         `json:"rawTrainName"`
	HasDynamicPricing bool           `json:"hasDynamicPricing"`
	TwoStorey         bool           `json:"twoStorey"`
	IsSuburban        bool           `json:"isSuburban"`
	Provider          string         `json:"provider"`
	RunDays           RunDays        `json:"runDays"`

	// mordabackend
	TariffsKeys     []string             `json:"tariffsKeys"`
	MinArrival      string               `json:"minArrival"`
	MaxArrival      string               `json:"maxArrival"`
	Companies       []Company            `json:"companies"` // Not used ?
	SubSegments     []SegmentWithTariffs `json:"subSegments"`
	HasTrainTariffs bool                 `json:"hasTrainTariffs"`

	// front
	IsDynamic bool `json:"isDynamic"`
}
