package models

import (
	"time"

	"a.yandex-team.ru/travel/trains/library/go/httputil/clients/common/models"
)

type SearchRequest struct {
	RID                string `json:"_rid"`
	PointFrom          string `json:"pointFrom"`
	PointTo            string `json:"pointTo"`
	TransportType      string `json:"transportType"`
	Timezones          string `json:"timezones"`
	When               string `json:"when"`
	Nearest            bool   `json:"nearest"`
	NationalVersion    string `json:"nationalVersion"`
	IsMobile           bool   `json:"isMobile"`
	AllowChangeContext bool   `json:"allowChangeContext"`
	Limit              int    `json:"limit"`
}

type ResponseSearchPoint struct {
	PointKey        string `json:"key"`
	Title           string `json:"title"`
	TitleWithType   string `json:"titleWithType"`
	TitleGenitive   string `json:"titleGenitive"`
	TitleAccusative string `json:"titleAccusative"`
	TitleLocative   string `json:"titleLocative"`
	Preposition     string `json:"preposition"`
	PopularTitle    string `json:"popularTitle"`
	ShortTitle      string `json:"shortTitle"`
	Slug            string `json:"slug"`
}

type ResponseSearchPoints struct {
	Nearest   bool                `json:"nearest"`
	PointFrom ResponseSearchPoint `json:"pointFrom"`
	PointTo   ResponseSearchPoint `json:"pointTo"`
}

type ResponseContext struct {
	IsChanged      bool                 `json:"isChanged"`
	Original       ResponseSearchPoints `json:"original"`
	Search         ResponseSearchPoints `json:"search"`
	TransportTypes []string             `json:"transportTypes"`
	LatestDatetime time.Time            `json:"latestDatetime"`
}

type TrainSchedulePlan struct {
	Code      string `json:"code"`
	Title     string `json:"title"`
	StartDate string `json:"startDate"`
	EndDate   string `json:"endDate"`
}

type Plans struct {
	Current TrainSchedulePlan `json:"current"`
	Next    TrainSchedulePlan `json:"next"`
}

type Teaser struct {
	ID            int32  `json:"id"`
	Importance    int32  `json:"importance"`
	Title         string `json:"title"`
	Content       string `json:"content"`
	MobileContent string `json:"mobileContent"`
	URL           string `json:"url"`
	ImageURL      string `json:"imageUrl"`
}

type SelectedTeasers struct {
	Normal    Teaser `json:"normal"`
	Attention Teaser `json:"ahtung"`
	Special   Teaser `json:"special"`
	Banner    Teaser `json:"banner"`
}

type Canonical struct {
	PointFrom     string `json:"pointFrom"`
	PointTo       string `json:"pointTo"`
	TransportType string `json:"transportType"`
}

type BaseSearchSegmentDays struct {
	DaysText string `json:"text"`
}

type ArchivalSegment struct {
	Title          string                `json:"title"`
	Arrival        time.Time             `json:"arrival"`
	Departure      time.Time             `json:"departure"`
	StationFrom    models.Station        `json:"stationFrom"`
	StationTo      models.Station        `json:"stationTo"`
	TransportType  models.Transport      `json:"transport"`
	Thread         models.Thread         `json:"thread"`
	DaysByTimezone BaseSearchSegmentDays `json:"daysByTimezone"`
}

type ArchivalData struct {
	Canonical      Canonical         `json:"canonical"`
	TransportTypes []string          `json:"transportTypes"`
	Segments       []ArchivalSegment `json:"segments"`
}

type SearchResult struct {
	Context      ResponseContext             `json:"context"`
	Plans        Plans                       `json:"plans"`
	Segments     []models.SegmentWithTariffs `json:"segments"`
	Teasers      SelectedTeasers             `json:"teasers"`
	Canonical    Canonical                   `json:"canonical"`
	ArchivalData ArchivalData                `json:"archivalData"`
}

type Errors interface{}

type SearchResponse struct {
	Errors Errors       `json:"errors"`
	Result SearchResult `json:"result"`
}
