package pathfinder

import (
	"context"
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/httputil/client"
	"a.yandex-team.ru/travel/trains/library/go/httputil/clients/pathfinder/models"
)

type Config struct {
	BaseURL string        `config:"pathfinder-baseurl,required"`
	Timeout time.Duration `config:"pathfinder-timeout,required"`
}

var DefaultConfig = Config{
	Timeout: 10 * time.Second,
}

type PathfinderClient struct {
	cfg        *Config
	logger     log.Logger
	httpClient *client.HTTPClient
}

func NewPathfinderClient(cfg *Config, logger log.Logger) (*PathfinderClient, error) {
	return NewPathfinderClientWithTransport(cfg, logger, nil)
}

func NewPathfinderClientWithTransport(
	cfg *Config, logger log.Logger, transport http.RoundTripper,
) (*PathfinderClient, error) {
	httpClient, err := client.NewHTTPClientWithTransport(cfg.BaseURL, cfg.Timeout, transport,
		0, 0, client.ContentTypeXML, logger, nil)
	if err != nil {
		return nil, err
	}
	return &PathfinderClient{
		cfg:        cfg,
		logger:     logger,
		httpClient: httpClient,
	}, nil
}

func (c *PathfinderClient) Search(ctx context.Context, request *models.SearchRequest) (*models.SearchResponse, error) {
	const fnName = "PathfinderClient.Search"

	var response models.SearchResponse
	err := c.httpClient.Get(ctx, "/search", request, &response)
	if err != nil {
		return nil, err
	}

	return &response, nil
}
