package models

var (
	PointTypeSettlement string = "settlement"
	PointTypeStation    string = "station"
	TransportTypeTrain  int    = 1
	SearchModeCommon    int    = 1
	SearchModeWizard    int    = 2
	SearchModeManyDays  int    = 3
)

type SearchRequest struct {
	FromType     string `json:"from_type"`
	FromID       int    `json:"from_id"`
	ToType       string `json:"to_type"`
	ToID         int    `json:"to_id"`
	Date         string `json:"date"`
	MaxTransfers int    `json:"max_transfers"`
	TType        int    `json:"ttype"`
	Mode         int    `json:"mode"`
	TimeLimit    int    `json:"time_limit"`
}

type SearchResponseSegment struct {
}

type SearchResponseVariant struct {
	Segments []SearchResponseSegment `xml:"pathfinder_segments"`
}

type SearchResponseGroup struct {
	Variants []SearchResponseVariant `xml:"variants"`
}

type SearchResponseRoute struct {
	ThreadID           string `xml:"thread_id,attr"`
	DepartureStationID int    `xml:"departure_station_id,attr"`
	ArrivalStationID   int    `xml:"arrival_station_id,attr"`
	DepartureDatetime  string `xml:"departure_datetime,attr"`
	ArrivalDatetimeID  string `xml:"arrival_datetime,attr"`
}

type SearchResponse struct {
	Variants []struct {
		Routes []SearchResponseRoute `xml:"route"`
	} `xml:"group>variant"`
}
