package models

import (
	commonModels "a.yandex-team.ru/travel/trains/library/go/httputil/clients/common/models"
)

type TransferVariantsWithPricesRequest struct {
	RID             string   `json:"_rid"`
	PointFrom       string   `json:"pointFrom"`
	PointTo         string   `json:"pointTo"`
	TLD             string   `json:"tld"`
	Language        string   `json:"language"`
	When            string   `json:"when"`
	TransportTypes  []string `json:"transportType"`
	IsBot           bool     `json:"isBot"`
	IncludePriceFee bool     `json:"includePriceFee"`
}

type TransferVariant struct {
	ID       string                            `json:"id"`
	Segments []commonModels.SegmentWithTariffs `json:"segments"`
}

const (
	QueryStatusQuerying = "querying"
	QueryStatusDone     = "done"
	QueryStatusError    = "error"
)

type TransferVariantsWithPricesResponse struct {
	TransferVariants []TransferVariant `json:"transfer_variants"`
	Status           string            `json:"status"`
}
