package models

import (
	"time"

	commonModels "a.yandex-team.ru/travel/trains/library/go/httputil/clients/common/models"
)

type TrainTariffsRequest struct {
	RID                      string    `json:"_rid"`
	PointFrom                string    `json:"pointFrom"`
	PointTo                  string    `json:"pointTo"`
	Dates                    []string  `json:"date"`
	ExpandedDay              bool      `json:"expanded_day"`
	StartTime                time.Time `json:"startTime"`
	EndTime                  time.Time `json:"endTime"`
	NationalVersion          string    `json:"national_version"`
	IncludePriceFee          bool      `json:"includePriceFee"`
	UseRailwayTZ             bool      `json:"useRailwayTZ"`
	UseWizardSource          bool      `json:"useWizardSource"`
	Experiment               bool      `json:"experiment"`
	PriceExpID               string    `json:"priceExpId"`
	Service                  string    `json:"service"`
	Partner                  string    `json:"partner"`
	UtmSource                string    `json:"utmSource"`
	YandexUID                string    `json:"yandex_uid"`
	ForceUfsOrder            bool      `json:"forceUfsOrder"`
	AllowInternationalRoutes bool      `json:"allowInternationalRoutes"`
	Asker                    string    `json:"asker"`
	YtpReferer               string    `json:"ytp_referer"`
	BanditType               string    `json:"bandit_type"`
	ICookie                  string    `json:"icookie"`
	ReqID                    string    `json:"req_id"`
	TestBuckets              string    `json:"test_buckets"`
	UserDevice               string    `json:"user_device"`
	MockImPath               string    `json:"mockImPath"`
	MockImAuto               bool      `json:"mockImAuto"`
}

type TrainTariffsResponse struct {
	Querying bool                              `json:"querying"`
	Segments []commonModels.SegmentWithTariffs `json:"segments"`
}
