package models

import (
	"time"
)

type TrainPlacePrice struct {
	Currency string `json:"currency,omitempty"`
	Value    string `json:"value,omitempty"`
}

type TrainPlacePriceDetails struct {
	TicketPrice   string `json:"ticket_price,omitempty"`
	ServicePrice  string `json:"service_price,omitempty"`
	Fee           string `json:"fee,omitempty"`
	SeveralPrices bool   `json:"several_prices,omitempty"`
}

type TrainPlace struct {
	CoachType              string                  `json:"coach_type,omitempty"`
	ServiceClass           string                  `json:"service_class,omitempty"`
	Count                  uint32                  `json:"count,omitempty"`
	LowerCount             uint32                  `json:"lower_count,omitempty"`
	UpperCount             uint32                  `json:"upper_count,omitempty"`
	LowerSideCount         uint32                  `json:"lower_side_count,omitempty"`
	UpperSideCount         uint32                  `json:"upper_side_count,omitempty"`
	MaxSeatsInTheSameCar   uint32                  `json:"max_seats_in_the_same_car,omitempty"`
	HasNonRefundableTariff bool                    `json:"has_non_refundable_tariff,omitempty"`
	Price                  *TrainPlacePrice        `json:"price,omitempty"`
	PriceDetails           *TrainPlacePriceDetails `json:"price_details,omitempty"`
}

type TariffBrokenClasses struct {
	Unknown     []uint32 `json:"unknown,omitempty"`
	Soft        []uint32 `json:"soft,omitempty"`
	Platzkarte  []uint32 `json:"platzkarte,omitempty"`
	Compartment []uint32 `json:"compartment,omitempty"`
	Suite       []uint32 `json:"suite,omitempty"`
	Common      []uint32 `json:"common,omitempty"`
	Sitting     []uint32 `json:"sitting,omitempty"`
}

type ThreadTitle struct {
	Type          string   `json:"type,omitempty"`
	TransportType string   `json:"t_type,omitempty"`
	TitleParts    []string `json:"title_parts,omitempty"`
	IsCombined    bool     `json:"is_combined,omitempty"`
	IsRing        bool     `json:"is_ring,omitempty"`
}

type DirectionTariffTrain struct {
	Arrival            time.Time            `json:"arrival_dt,omitempty"`
	ArrivalStationID   int32                `json:"arrival_station_id,omitempty"`
	Departure          time.Time            `json:"departure_dt,omitempty"`
	DepartureStationID int32                `json:"departure_station_id,omitempty"`
	Number             string               `json:"number,omitempty"`
	DisplayNumber      string               `json:"display_number,omitempty"`
	HasDynamicPricing  bool                 `json:"has_dynamic_pricing,omitempty"`
	TwoStorey          bool                 `json:"two_storey,omitempty"`
	IsSuburban         bool                 `json:"is_suburban,omitempty"`
	CoachOwners        []string             `json:"coach_owners,omitempty"`
	ElectronicTicket   bool                 `json:"electronic_ticket,omitempty"`
	FirstCountryCode   string               `json:"first_country_code,omitempty"`
	LastCountryCode    string               `json:"last_country_code,omitempty"`
	Places             []*TrainPlace        `json:"places,omitempty"`
	BrokenClasses      *TariffBrokenClasses `json:"broken_classes,omitempty"`
	TitleDict          *ThreadTitle         `json:"title_dict,omitempty"`
	Provider           string               `json:"provider,omitempty"`
	RawTrainName       string               `json:"raw_train_name,omitempty"`
	HasThread          bool                 `json:"has_thread,omitempty"`
}
