PROTO_LIBRARY()

OWNER(
    g:trains
    maxim-k
)

INCLUDE_TAGS(GO_PROTO)

GRPC()

USE_COMMON_GOOGLE_APIS(api/annotations)

PEERDIR(
    travel/proto
    travel/proto/trains
    travel/trains/search_api/api/seo_direction
    travel/trains/search_api/api/price_calendar
)

SRCS(
    features.proto
    min_tariffs.proto
    points.proto
    segment.proto
    search_context.proto
    search_api_service.proto
    variant.proto
)

IF (GO_PROTO)
    SRCS(grpc_gateway.proto)

    SET_APPEND(
        PROTO_PATH
        -I
        ${ARCADIA_ROOT}/vendor/github.com/grpc-ecosystem/grpc-gateway
    )

    ADDINCL(${ARCADIA_ROOT}/vendor/github.com/grpc-ecosystem/grpc-gateway)

    GO_GRPC_GATEWAY_SWAGGER_SRCS(search_api_service.proto)

    RESOURCE(
        search_api_service.swagger.json search_api_service.swagger.json
    )
ENDIF()

END()

RECURSE(
    tariffs
    seo_direction
    price_calendar
)
