package main

import (
	"a.yandex-team.ru/travel/library/go/grpcgateway"
	grpcserver "a.yandex-team.ru/travel/library/go/grpcutil/server"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
	"a.yandex-team.ru/travel/library/go/unifiedagent"
	"a.yandex-team.ru/travel/trains/search_api/internal/app"
)

type TvmConfig struct {
	Enabled   bool     `config:"tvm-enabled"`
	WhiteList []uint32 `config:"tvm-white-list"`
}

type Config struct {
	EnvType            string `config:"yenv-type,required"`
	App                app.Config
	HTTP               httpserver.HTTPConfig
	Grpc               grpcserver.GrpcConfig
	GrpcGateway        grpcgateway.Config
	Metrics            metricsserver.MetricsConfig
	Logging            logging.Config
	Tvm                TvmConfig
	UnifiedAgentClient unifiedagent.ClientConfig
}

var DefaultTvmConfig = TvmConfig{
	Enabled:   false,
	WhiteList: nil,
}

var Cfg = Config{
	EnvType:            "development",
	App:                app.DefaultConfig,
	HTTP:               httpserver.DefaultHTTPConfig,
	Grpc:               grpcserver.DefaultGrpcConfig,
	GrpcGateway:        grpcgateway.DefaultConfig,
	Metrics:            metricsserver.DefaultMetricsConfig,
	Logging:            logging.DefaultConfig,
	Tvm:                DefaultTvmConfig,
	UnifiedAgentClient: unifiedagent.DefaultClientConfig,
}
