package main

import (
	"context"
	"fmt"

	"a.yandex-team.ru/library/go/core/log"
	arczap "a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/travel/library/go/configuration"
	"a.yandex-team.ru/travel/library/go/metrics"

	app "a.yandex-team.ru/travel/trains/search_api/internal/template_dump_app"
)

func main() {
	maxprocs.AdjustAuto()

	ctx, ctxCancel := context.WithCancel(context.Background())
	defer ctxCancel()

	cfgLoader := configuration.NewDefaultConfitaLoader()
	cfg := DefaultConfig
	err := cfgLoader.Load(ctx, &cfg)

	if err != nil {
		fmt.Println("can not load configuration:", err)
		return
	}

	level, err := log.ParseLevel(cfg.Logging.Level)
	if err != nil {
		fmt.Println("failed to parse log level, err:", err)
		return
	}
	zapConfig := arczap.ConsoleConfig(level)
	l, err := zapConfig.Build()
	if err != nil {
		fmt.Println("failed to create logger, err:", err)
		return
	}
	logger := &arczap.Logger{L: l}

	defer func() {
		err = logger.L.Sync()
		if err != nil {
			fmt.Println("failed to close logger:", err)
			return
		}
	}()

	rootRegistry := metrics.NewRegistryWithDeployTags()
	appMetrics := metrics.NewAppMetrics(rootRegistry.WithPrefix("app"))
	metrics.SetGlobalAppMetrics(appMetrics)

	app, err := app.NewApp(logger, &cfg.App)
	if err != nil {
		logger.Fatal("Error while running application", log.Error(err))
	}
	defer app.Destroy()
}
