package app

import (
	"a.yandex-team.ru/travel/trains/library/go/grpcutil/clients/trainbanditapi"

	"a.yandex-team.ru/travel/trains/search_api/internal/direction"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/geo"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/i18n"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/logbroker"
	tariffcache "a.yandex-team.ru/travel/trains/search_api/internal/pkg/tariffs/cache"
	"a.yandex-team.ru/travel/trains/search_api/internal/searcher"
	"a.yandex-team.ru/travel/trains/search_api/internal/seo"
)

type Config struct {
	YtLockCluster string `config:"ytlock-cluster, required" yaml:"ytlock-cluster"`
	YtToken       string `config:"yt-token, required" yaml:"yt-token"`

	Searcher       searcher.Config
	Direction      direction.Config
	Geobase        geo.Config
	I18n           i18n.Config
	Dict           dict.Config
	TariffCache    tariffcache.Config `yaml:"tariff-cache"`
	Seo            seo.Config
	TrainBanditAPI trainbanditapi.ClientConfig `yaml:"trainbanditapi"`

	LogbrokerConsumer logbroker.ConsumerConfig `yaml:"logbroker-consumer"`
	LogbrokerProducer logbroker.ProducerConfig `yaml:"logbroker-producer"`
}

var DefaultConfig = Config{
	YtLockCluster: "locke",

	Direction:      direction.DefaultConfig,
	Searcher:       searcher.DefaultConfig,
	Geobase:        geo.DefaultConfig,
	I18n:           i18n.DefaultConfig,
	Dict:           dict.DefaultConfig,
	TariffCache:    tariffcache.DefaultConfig,
	Seo:            seo.DefaultConfig,
	TrainBanditAPI: trainbanditapi.DefaultConfig,

	LogbrokerConsumer: logbroker.DefaultConsumerConfig,
	LogbrokerProducer: logbroker.DefaultProducerConfig,
}
