package direction

import (
	"a.yandex-team.ru/travel/trains/search_api/internal/direction/filters"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
)

type Config struct {
	TravelURL             string `config:"travel-url,required"`
	Filters               filters.Config
	DefaultLanguage       lang.Lang
	FrontendLanguages     map[lang.Lang]bool
	LanguageFallbacks     map[lang.Lang]lang.Lang
	LanguageCaseFallbacks map[lang.LinguisticForm]lang.LinguisticForm
}

var DefaultConfig = Config{
	TravelURL: "https://travel-test.yandex.ru",
	Filters:   filters.DefaultConfig,

	DefaultLanguage: lang.Ru,
	FrontendLanguages: map[lang.Lang]bool{
		lang.Ru: true,
		lang.Tr: true,
		lang.Uk: true,
	},
	LanguageFallbacks: map[lang.Lang]lang.Lang{
		lang.Tr: lang.En,
		lang.Uk: lang.Ru,
	},
	LanguageCaseFallbacks: map[lang.LinguisticForm]lang.LinguisticForm{
		{Lang: lang.Uk, Case: lang.Genitive}: {Lang: lang.Ru, Case: lang.Genitive},
	},
}
