package filters

import "a.yandex-team.ru/travel/trains/search_api/internal/direction/segments"

const (
	brandName         FilterName = "brand"
	coachTypeName     FilterName = "coach_type"
	placeCountName    FilterName = "place_count"
	facilityName      FilterName = "facility"
	arrivalTimeName   FilterName = "arrival_time"
	priceName         FilterName = "price"
	departureTimeName FilterName = "departure_time"
)

type FilterName string

type BaseFilter struct {
	name           FilterName
	variantStorage VariantStorage
}

func NewBaseFilter(name FilterName) BaseFilter {
	return BaseFilter{
		name:           name,
		variantStorage: NewVariantStorage(),
	}
}

func (f BaseFilter) Name() FilterName {
	return f.name
}

func (f BaseFilter) IsSelectedVariant(v segments.TrainVariant) bool {
	return f.variantStorage.IsSelectedVariant(v)
}

func (f BaseFilter) MakeAvailableVariant(v segments.TrainVariant) {
	f.variantStorage.MakeAvailableVariant(v)
}

func (f BaseFilter) HasSelectedVariants() bool {
	return f.variantStorage.HasSelectedVariants()
}
