package filters

import (
	"a.yandex-team.ru/travel/library/go/funcnames"
	tpb "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/trains/search_api/internal/direction/segments"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/helpers"
)

var coachTypeLoadSelectedCaller funcnames.Caller
var groupApplyCaller funcnames.Caller

func init() {
	coachTypeLoadSelectedCaller = funcnames.BuildFullName((&CoachTypeFilter{}).LoadSelected)
	groupApplyCaller = funcnames.BuildFullName((&Group{}).Apply)
}

func getFullSelector(n int) []bool {
	result := make([]bool, n)
	for i := range result {
		result[i] = true
	}
	return result
}

func getMinPrice(variants segments.TrainVariants) *tpb.TPrice {
	var minPrice *tpb.TPrice
	for _, v := range variants {
		if v.Place == nil {
			continue
		}
		minPrice = helpers.GetMinPrice(minPrice, v.Place.Price)
	}
	return minPrice
}
