package filters

import "a.yandex-team.ru/travel/trains/search_api/internal/direction/segments"

type variantOption interface {
	isVariantOption()
}

type VariantStorage struct {
	variantsByOptions map[variantOption]map[segments.TrainVariant]struct{}
	selectedOptions   map[variantOption]bool
	availableVariants map[segments.TrainVariant]bool
}

func NewVariantStorage() VariantStorage {
	return VariantStorage{
		variantsByOptions: make(map[variantOption]map[segments.TrainVariant]struct{}),
		selectedOptions:   make(map[variantOption]bool),
		availableVariants: make(map[segments.TrainVariant]bool),
	}
}

func (vs VariantStorage) MakeAvailableVariant(v segments.TrainVariant) {
	vs.availableVariants[v] = true
}

func (vs VariantStorage) IsAvailableVariant(v segments.TrainVariant) bool {
	return vs.availableVariants[v]
}

func (vs VariantStorage) IsSelectedVariant(v segments.TrainVariant) bool {
	for opt := range vs.selectedOptions {
		if !vs.selectedOptions[opt] {
			continue
		}

		variants := vs.variantsByOptions[opt]
		if variants == nil {
			continue
		}
		if _, found := variants[v]; found {
			return true
		}
	}
	return false
}

func (vs VariantStorage) HasSelectedVariants() bool {
	if len(vs.selectedOptions) == 0 {
		return false
	}

	for opt := range vs.selectedOptions {
		if len(vs.variantsByOptions[opt]) > 0 {
			return true
		}
	}
	return false
}

func (vs VariantStorage) SelectOption(opt variantOption) {
	vs.selectedOptions[opt] = true
}

func (vs VariantStorage) IsSelectedOption(opt variantOption) bool {
	return vs.selectedOptions[opt]
}

func (vs VariantStorage) AddVariant(v segments.TrainVariant, opts ...variantOption) {
	for _, opt := range opts {
		if variantSet, found := vs.variantsByOptions[opt]; found {
			variantSet[v] = struct{}{}
		} else {
			vs.variantsByOptions[opt] = map[segments.TrainVariant]struct{}{v: {}}
		}
	}
}

func (vs VariantStorage) GetAvailableVariantsByOption(opt variantOption) segments.TrainVariants {
	var result segments.TrainVariants
	for v := range vs.variantsByOptions[opt] {
		if vs.availableVariants[v] {
			result = append(result, v)
		}
	}
	return result
}
