package models

type Response interface {
	IsEmpty() bool
	IsError() bool
	ErrMsg() string
}

type ResponseCode int

const (
	EmptyCode ResponseCode = 204
	ErrorCode ResponseCode = 400
)

type ErrorResponse struct {
	Code int    `json:"error_code"`
	Msg  string `json:"error"`
}

func ResponseFromError(code ResponseCode, err error) *ErrorResponse {
	return &ErrorResponse{
		Code: int(code),
		Msg:  err.Error(),
	}
}

func (r *ErrorResponse) IsError() bool {
	return ResponseCode(r.Code) == ErrorCode
}

func (r *ErrorResponse) IsEmpty() bool {
	return ResponseCode(r.Code) == EmptyCode
}

func (r *ErrorResponse) ErrMsg() string {
	return r.Msg
}
