package query

import (
	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/travel/library/go/funcnames"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/consts"
)

const kaliningradRegionID uint32 = 10857

const (
	abkhaziaID     = 21619
	armeniaID      = 168
	belarusID      = 149
	estoniaID      = 179
	kazakhstanID   = 159
	kyrgyzstanID   = 207
	lithuaniaID    = 117
	latviaID       = 206
	moldovaID      = 208
	russiaID       = 225
	tajikistanID   = 209
	turkmenistanID = 170
	ukraineID      = 187
	uzbekistanID   = 171
)

var CountriesWhereSaleTicketsIds = map[int32]bool{
	abkhaziaID:     true,
	armeniaID:      true,
	belarusID:      true,
	estoniaID:      true,
	kazakhstanID:   true,
	kyrgyzstanID:   true,
	lithuaniaID:    true,
	latviaID:       true,
	moldovaID:      true,
	russiaID:       true,
	tajikistanID:   true,
	turkmenistanID: true,
	ukraineID:      true,
	uzbekistanID:   true,
}

const (
	futureDaysLimit = 365 - consts.DaysToPast
)

var (
	parseDateFnCaller     funcnames.Caller
	parseLanguageFnCaller funcnames.Caller
	parsePointsFnCaller   funcnames.Caller
)

func init() {
	parseDateFnCaller = funcnames.BuildFullName(ParseDate)
	parseLanguageFnCaller = funcnames.BuildFullName(ParseDate)
	parsePointsFnCaller = funcnames.BuildFullName(ParseDate)
}

var (
	InvalidDateFormatError = xerrors.New("invalid date value: it should be in YYYY-MM-DD format")
	PastDateError          = xerrors.New("invalid date value: it should be present date")
	FutureDateError        = xerrors.Errorf("invalid date value: it should be within %d days in future", futureDaysLimit)
)

type pointType string

const (
	departure pointType = "departure"
	arrival   pointType = "arrival"
)

var (
	EqualPointsError               = xerrors.New("arrival point should be different from the departure point")
	CrossingKaliningradBorderError = xerrors.New("crossing of Kaliningrad region border is not allowed")
	ProhibitedSalesError           = xerrors.New("sale is prohibited for these direction points")
)
