package query

import (
	"time"

	"a.yandex-team.ru/travel/trains/search_api/internal/direction/filters"
	"a.yandex-team.ru/travel/trains/search_api/internal/direction/sorting"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/points"
)

type RawDirectionQuery struct {
	DeparturePointKey        string
	DepartureSettlementGeoID string
	ArrivalPointKey          string
	ArrivalSettlementGeoID   string
	DepartureDate            string
	ExpFlags                 string
	MainReqID                *string
	Language                 string
	OrderBy                  string
	TLD                      string

	BrandFilter     []string
	CoachTypeFilter []string
}

type DirectionQuery struct {
	DeparturePoint    points.Point
	ArrivalPoint      points.Point
	DepartureDate     *time.Time
	DepartureLocation *time.Location
	MainReqID         *string
	Language          lang.Lang
	Sorting           sorting.Sorter
	FilterGroup       *filters.Group
	TLD               string
}
