package segments

import (
	"time"

	tpb "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/api/tariffs"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/helpers"
)

type (
	TrainSegments []*TrainSegment
	TrainSegment  struct {
		TrainNumber       string
		TrainTitle        *rasp.TThreadTitle
		TrainBrand        *rasp.TNamedTrain
		ThreadType        string
		Duration          time.Duration
		DepartureStation  *rasp.TThreadStation
		DepartureLocalDt  time.Time
		ArrivalStation    *rasp.TThreadStation
		ArrivalLocalDt    time.Time
		ElectronicTicket  bool
		Places            []*tariffs.TrainPlace
		UpdatedAt         *time.Time
		DisplayNumber     string
		HasDynamicPricing bool
		TwoStorey         bool
		IsSuburban        bool
		CoachOwners       []string
		FirstCountryCode  string
		LastCountryCode   string
		BrokenClasses     *tariffs.TariffBrokenClasses
		Provider          string
		RawTrainName      string

		IsTheCheapest bool
		IsTheFastest  bool
	}

	TrainVariant struct {
		Segment *TrainSegment
		Place   *tariffs.TrainPlace
	}
	TrainVariants []TrainVariant
)

func (s *TrainSegment) GetMinPrice() (minPrice *tpb.TPrice) {
	for _, place := range s.Places {
		minPrice = helpers.GetMinPrice(minPrice, place.Price)
	}
	return
}
