package serialization

import (
	"math"

	tpb "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/trains/search_api/internal/direction/models"
)

var currencyToCode = map[tpb.ECurrency]string{
	tpb.ECurrency_C_UNKNOWN: "UNKNOWN",
	tpb.ECurrency_C_RUB:     "RUB",
	tpb.ECurrency_C_USD:     "USD",
	tpb.ECurrency_C_EUR:     "EUR",
	tpb.ECurrency_C_JPY:     "JPY",
}

func DumpPrice(price *tpb.TPrice) *models.PriceResponse {
	if price == nil {
		return nil
	}

	value := float64(price.Amount) / math.Pow10(int(price.Precision))
	if value > 100.0 {
		value = math.Round(value)
	}

	return &models.PriceResponse{
		Value:    value,
		Currency: currencyToCode[price.Currency],
	}
}
