package handler

import (
	"context"
	"time"

	tariffmodels "a.yandex-team.ru/travel/trains/library/go/tariffs/models"
	pcpb "a.yandex-team.ru/travel/trains/search_api/api/price_calendar"
	seopb "a.yandex-team.ru/travel/trains/search_api/api/seo_direction"
	dirmodels "a.yandex-team.ru/travel/trains/search_api/internal/direction/models"
	"a.yandex-team.ru/travel/trains/search_api/internal/direction/query"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/lang"
	"a.yandex-team.ru/travel/trains/search_api/internal/searcher/models"
)

type App interface {
	Search(
		context.Context,
		string, string,
		string, string,
		string, string,
		bool, bool,
		models.UserArgs,
		models.TestContext,
	) (*models.TransferVariantsResponse, error)

	Direction(
		ctx context.Context,
		rawQuery *query.RawDirectionQuery,
	) (dirmodels.Response, error)

	OpenDirection(
		ctx context.Context,
		rawQuery *query.RawDirectionQuery,
	) (dirmodels.Response, error)

	Index(
		ctx context.Context,
		departurePointExpressID int,
		arrivalPointExpressID int,
		departureDate time.Time,
		info []*tariffmodels.DirectionTariffTrain,
	) error

	SeoDirection(
		ctx context.Context,
		fromSlug string,
		toSlug string,
		language lang.Lang,
	) (*seopb.SeoDirectionResponse, error)

	PriceCalendar(
		ctx context.Context,
		pointFrom string,
		pointTo string,
		userArgs models.UserArgs,
	) (*pcpb.PriceCalendarResponse, error)
}
