package clock

import (
	"sync/atomic"
	"time"

	"github.com/jonboulle/clockwork"
)

var globalClock atomic.Value

func init() {
	SetReal()
}

func set(c clockwork.Clock) {
	globalClock.Store(&c)
}

func get() clockwork.Clock {
	return *globalClock.Load().(*clockwork.Clock)
}

func SetReal() {
	set(clockwork.NewRealClock())
}

func FreezeAt(t time.Time) {
	set(clockwork.NewFakeClockAt(t))
}

func FreezeAtDate(year, month, day int) {
	set(clockwork.NewFakeClockAt(
		time.Date(year, time.Month(month), day, 0, 0, 0, 0, time.UTC)),
	)
}

func Now() time.Time {
	return get().Now()
}

func Since(t time.Time) time.Duration {
	return get().Since(t)
}

func Sleep(d time.Duration) {
	get().Sleep(d)
}

func NewTicker(d time.Duration) clockwork.Ticker {
	return get().NewTicker(d)
}

func After(d time.Duration) <-chan time.Time {
	return get().After(d)
}
