package daytime

import (
	"time"

	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/clock"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/consts"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/date"
)

type DayTime int

func (d DayTime) Int32() int32 {
	return int32(d)
}

func (d DayTime) Duration() time.Duration {
	return time.Duration(d) * time.Second
}

func (d DayTime) Combine(day time.Time) time.Time {
	truncated := date.ReplaceLocation(
		date.DateFromTime(day),
		consts.MskLocation,
	)
	return truncated.Add(d.Duration())
}

func FromTime(t time.Time) DayTime {
	return DayTime((t.Hour()*60+t.Minute())*60 + t.Second())
}

func Now() DayTime {
	return FromTime(clock.Now())
}
