package date

import (
	"time"

	proto "a.yandex-team.ru/travel/proto"
)

const (
	DateTimeISOFormat         = "2006-01-02T15:04:05-07:00"
	DateTimeISOWithNanoFormat = "2006-01-02T15:04:05.000000-07:00"
	DateISOFormat             = "2006-01-02"
)

func Date(year, month, day int) time.Time {
	return time.Date(year, time.Month(month), day, 0, 0, 0, 0, time.UTC)
}

func DateFromTime(d time.Time) time.Time {
	return time.Date(d.Year(), d.Month(), d.Day(), 0, 0, 0, 0, time.UTC)
}

func DateFromString(s string) (time.Time, error) {
	return time.Parse(DateISOFormat, s)
}

func DateFromStringInLocation(s string, loc *time.Location) (time.Time, error) {
	return time.ParseInLocation(DateISOFormat, s, loc)
}

func DateToString(d time.Time) string {
	return d.Format(DateISOFormat)
}

func DateFromTimeLocal(d time.Time) time.Time {
	return time.Date(d.Year(), d.Month(), d.Day(), 0, 0, 0, 0, d.Location())
}

func ReplaceLocation(d time.Time, loc *time.Location) time.Time {
	return time.Date(d.Year(), d.Month(), d.Day(), d.Hour(), d.Minute(), d.Second(), d.Nanosecond(), loc)
}

func GetDateFromProto(d *proto.TDate) time.Time {
	return Date(int(d.Year), int(d.Month), int(d.Day))
}

func GetProtoFromDate(d time.Time) *proto.TDate {
	return &proto.TDate{
		Year:  int32(d.Year()),
		Month: int32(d.Month()),
		Day:   int32(d.Day()),
	}
}
