package dict

import (
	"time"

	"a.yandex-team.ru/travel/library/go/resourcestorage"
)

type Config struct {
	UpdateInterval   time.Duration `config:"dict-update-interval" yaml:"update-interval"`
	S3DictPathPrefix string        `config:"dict-s3-prefix,required" yaml:"s3-prefix"`
	S3AccessKey      string        `config:"dict-s3-access-key,required" yaml:"s3-access-key"`
	S3Secret         string        `config:"dict-s3-secret,required" yaml:"s3-secret"`
	S3Storage        StorageConfig `config:"dict-s3-secret,required" yaml:"s3-storage"`
}

type StorageConfig struct {
	LocalStoragePath  string `yaml:"local-path"`
	S3StorageEndpoint string `yaml:"endpoint"`
	S3StorageBucket   string `yaml:"bucket"`
	S3StorageRegion   string `yaml:"region"`
}

var DefaultConfig = Config{
	S3DictPathPrefix: "dicts",
	UpdateInterval:   5 * time.Minute,
	S3Storage:        StorageConfig(resourcestorage.DefaultS3StorageConfig),
}
