package factories

import (
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type CountryFactory struct {
	country      *rasp.TCountry
	repoRegistry *registry.RepositoryRegistry
}

func NewCountryFactory(repoRegistry *registry.RepositoryRegistry) *CountryFactory {
	country := &rasp.TCountry{
		Id: testutils.Counter.Int32(),
	}
	return &CountryFactory{
		country:      country,
		repoRegistry: repoRegistry,
	}
}

func (f *CountryFactory) Create() *rasp.TCountry {
	f.repoRegistry.GetCountryRepo().Add(f.country)
	return f.country
}
