package factories

import (
	"time"

	tpb "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type SettlementFactory struct {
	settlement   *rasp.TSettlement
	repoRegistry *registry.RepositoryRegistry
}

func NewSettlementFactory(repoRegistry *registry.RepositoryRegistry) *SettlementFactory {
	settlement := &rasp.TSettlement{
		Id:       testutils.Counter.Int32(),
		Majority: rasp.TSettlement_MAJORITY_CAPITAL,
	}
	return &SettlementFactory{
		settlement:   settlement,
		repoRegistry: repoRegistry,
	}
}

func (f *SettlementFactory) Create() *rasp.TSettlement {
	f.repoRegistry.GetSettlementRepo().Add(f.settlement)
	return f.settlement
}

func (f *SettlementFactory) WithMajority(m rasp.TSettlement_EMajority) *SettlementFactory {
	f.settlement.Majority = m
	return f
}

func (f *SettlementFactory) WithSlug(s string) *SettlementFactory {
	f.settlement.Slug = s
	return f
}

func (f *SettlementFactory) WithTitle(s string) *SettlementFactory {
	f.settlement.Title = &tpb.TTranslationCase{Ru: &tpb.TTranslationCaseRu{Nominative: s}}
	return f
}

func (f *SettlementFactory) WithLocation(loc *time.Location) *SettlementFactory {
	f.settlement.TimeZoneId = NewTimeZoneFactory(f.repoRegistry).WithCode(loc.String()).Create().Id
	return f
}

func (f *SettlementFactory) WithCountry(country *rasp.TCountry) *SettlementFactory {
	f.settlement.CountryId = country.Id
	return f
}
