package factories

import (
	"time"

	tpb "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type StationFactory struct {
	station      *rasp.TStation
	settlement   *rasp.TSettlement
	repoRegistry *registry.RepositoryRegistry
}

func NewStationFactory(repoRegistry *registry.RepositoryRegistry) *StationFactory {
	station := &rasp.TStation{
		Id:               testutils.Counter.Int32(),
		TransportType:    rasp.TTransport_TYPE_TRAIN,
		Majority:         rasp.TStation_MAJORITY_MAIN_IN_CITY,
		MajorityId:       int32(rasp.TStation_MAJORITY_MAIN_IN_CITY),
		IsSearchableFrom: true,
		IsSearchableTo:   false,
	}
	return &StationFactory{
		station:      station,
		repoRegistry: repoRegistry,
	}
}

func (f *StationFactory) Create() *rasp.TStation {
	if f.settlement == nil {
		f.settlement = NewSettlementFactory(f.repoRegistry).Create()
	}

	f.station.SettlementId = f.settlement.Id
	f.repoRegistry.GetStationRepo().Add(f.station)
	return f.station
}

func (f *StationFactory) WithMajority(m rasp.TStation_EMajority) *StationFactory {
	f.station.Majority = m
	f.station.MajorityId = int32(m)
	return f
}

func (f *StationFactory) WithTransportType(t rasp.TTransport_EType) *StationFactory {
	f.station.TransportType = t
	return f
}

func (f *StationFactory) WithSettlement(s *rasp.TSettlement) *StationFactory {
	f.settlement = s
	return f
}

func (f *StationFactory) WithRailwayLocation(loc *time.Location) *StationFactory {
	f.station.RailwayTimeZoneId = NewTimeZoneFactory(f.repoRegistry).WithCode(loc.String()).Create().Id
	return f
}

func (f *StationFactory) WithTitle(s string) *StationFactory {
	f.station.Title = &tpb.TTranslation{Ru: s}
	return f
}
