package factories

import (
	"strconv"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type StationCodeFactory struct {
	station      *rasp.TStation
	stationCode  *rasp.TStationCode
	repoRegistry *registry.RepositoryRegistry
}

func NewStationCodeFactory(repoRegistry *registry.RepositoryRegistry) *StationCodeFactory {
	stationCode := &rasp.TStationCode{
		Code:     "code_" + strconv.Itoa(testutils.Counter.Int()),
		SystemId: rasp.ECodeSystem_CODE_SYSTEM_EXPRESS,
	}
	return &StationCodeFactory{
		stationCode:  stationCode,
		repoRegistry: repoRegistry,
	}
}

func (f *StationCodeFactory) Create() *rasp.TStationCode {
	if f.station == nil {
		f.station = NewStationFactory(f.repoRegistry).Create()
	}

	f.stationCode.StationId = f.station.Id
	f.repoRegistry.GetStationCodeRepo().Add(f.stationCode)
	return f.stationCode
}

func (f *StationCodeFactory) WithStation(station *rasp.TStation) *StationCodeFactory {
	f.station = station
	return f
}

func (f *StationCodeFactory) WithSystemID(systemID rasp.ECodeSystem) *StationCodeFactory {
	f.stationCode.SystemId = systemID
	return f
}

func (f *StationCodeFactory) WithCode(code string) *StationCodeFactory {
	f.stationCode.Code = code
	return f
}
