package factories

import (
	"time"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/date/daytime"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/date/runmask"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/dict/registry"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/testutils"
)

type ThreadFactory struct {
	thread       *rasp.TThread
	repoRegistry *registry.RepositoryRegistry
}

func NewThreadFactory(repoRegistry *registry.RepositoryRegistry) *ThreadFactory {
	thread := &rasp.TThread{
		Id:            testutils.Counter.Int32(),
		TransportType: rasp.TTransport_TYPE_TRAIN,
		YearDays:      runmask.NewFullMask().RawMask(),
		TzStartTime:   0,
	}
	return &ThreadFactory{
		thread:       thread,
		repoRegistry: repoRegistry,
	}
}

func (f *ThreadFactory) Create() *rasp.TThread {
	f.repoRegistry.GetThreadRepo().Add(f.thread)
	return f.thread
}

func (f *ThreadFactory) WithTransportType(t rasp.TTransport_EType) *ThreadFactory {
	f.thread.TransportType = t
	return f
}

func (f *ThreadFactory) WithYearDays(m *runmask.RunMask) *ThreadFactory {
	f.thread.YearDays = m.RawMask()
	return f
}

func (f *ThreadFactory) WithTzStartTime(t time.Time) *ThreadFactory {
	f.thread.TzStartTime = daytime.FromTime(t).Int32()
	return f
}
